﻿<%@ Control Language="C#" AutoEventWireup="true" EnableViewState="true" CodeBehind="PreviewControl.ascx.cs" Inherits="ccPublisherWeb.PreviewControl" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>
<%@ Register TagPrefix="asp" Namespace="System.Web.UI" Assembly="System.Web" %>

<script language="javascript" type="text/javascript">
    

    function extChangeView(viewMode) {
        document.getElementById("<%# hdViewSetting.ClientID %>").value = viewMode;

        setTimeout(function() {
            <%# Page.ClientScript.GetPostBackEventReference(btExtChangeView, "") %>;
        }, 0);
    }

    function extChangeAutoPrev(state) {
        document.getElementById("<%# hdExtAutoPrev.ClientID %>").value = state ? "1" : "0";

        document.getElementById("<%# chkAutoPrev.ClientID %>").checked = state;

        

        setTimeout(function() {
            <%# Page.ClientScript.GetPostBackEventReference(btExtAutoPrev, "") %>;
        }, 0);
    }

    function swapExternalCADPreview(imageSRC, viewMode, autoPrev, is3D) {
        try {
            parent.Leer.swapImage(imageSRC, viewMode, autoPrev, is3D);
        } catch (e) { }
    }

    function open3DViewer(url) {
        if(viewerActive) {
            $(".Dialog_AppletViewer IFRAME").attr("src",
                "<%# ResolveUrl("~/JavaApplets/Viewer3D.aspx") %>" + url +
                "&width=" + $(".Dialog_AppletViewer .SizeFrame").width() +
                "&height=" + ($(".Dialog_AppletViewer .SizeFrame").height() - 5));
        }
    }

    function open2DViewer(url) {
        if(viewerActive) {
            $(".Dialog_AppletViewer IFRAME").attr("src",
                "<%# ResolveUrl("~/JavaApplets/Viewer2D.aspx") %>" + url +
                "&width=" + $(".Dialog_AppletViewer .SizeFrame").width() +
                "&height=" + ($(".Dialog_AppletViewer .SizeFrame").height() - 5));
        }
    }

    function start3DViewerExt() {
        prepareViewer("<%# TextDic.TxGet("Text_Ansicht3DVorschau") %>");
        setTimeout(function() { getpreview("3D"); }, 200);
    }
    
    function start2DViewerExt() {
        prepareViewer("<%# TextDic.TxGet("Text_Ansicht2DVorschau") %>");
       setTimeout(function() { getpreview("2D"); }, 200);
    }
    
    function getpreview(previewtype) {
        var targetpath = '';

        var viewertype = previewtype == '3D' ? 'Vrml' : 'Dxf';
        var viewdirection = $('#<%# hdViewSetting.ClientID %>').val();
        var showhiddenlines = 'false';
        
        if ($('#SHOW_HIDDENLINE').length) {
            showhiddenlines =
                $('#SHOW_HIDDENLINE').is(':checked') ? 'true' : 'false';
        }

        var rndm = new Date();

        var postUrl =
            'CADBoxPreviewHandler.ashx?' +
            '&SESSIONID=<%# PipeSessionId %>' +
            '&TYPE=' + viewertype +
            '&VIEWDIRECTION=' + viewdirection +
            '&SHOWHIDDENLINES=' + showhiddenlines +
            '&TIMEOUT=<%# Session.Timeout %>' +
            '&RANDOM=' + rndm.getTime();

        var xmlHttp = ccPublisherWeb.getXmlHttp();

        if (xmlHttp) {
            xmlHttp.open('GET', postUrl, false);
            xmlHttp.onreadystatechange = function () {
                if (xmlHttp.readyState == 4) {
                    targetpath = xmlHttp.responseText;
                    
                    if (targetpath != '') {
                        switch (previewtype) {
                        case '3D':
                            open3DViewer('?random=' + rndm.getTime() + '&scene=' + targetpath);
                            break;
                        case '2D':
                            targetpath = targetpath.replace('\\', '/');
                            open2DViewer('?random=' + rndm.getTime() + '&scene=' + targetpath);
                            break;
                        }
                    }
                }
            };

            xmlHttp.send(null);
        }
    }
</script>

<asp:UpdatePanel ID="PrevPanel" UpdateMode="Conditional" runat="server">  
    <ContentTemplate>
        <div id="Toolbar" class="CADViewerButtons">
            <div class="Header"></div>
            <div class="Content">
                <asp:PlaceHolder ID="PLH_ViewsCADViewer" runat="server">
                    <asp:LinkButton ID="BTN_VIEW_DIR_FRONT" CssClass="CADViewerButton_Front" runat="server" OnClientClick="js_ChangeView('VIEW_DIR_FRONT')" OnClick="ChangeView" EnableViewState="false"></asp:LinkButton>
                    <asp:LinkButton ID="BTN_VIEW_DIR_RIGHT" CssClass="CADViewerButton_Right" runat="server" OnClientClick="js_ChangeView('VIEW_DIR_RIGHT')" OnClick="ChangeView" EnableViewState="false"></asp:LinkButton>
                    <asp:LinkButton ID="BTN_VIEW_DIR_TOP" CssClass="CADViewerButton_Top" runat="server" OnClientClick="js_ChangeView('VIEW_DIR_TOP')" OnClick="ChangeView" EnableViewState="false"></asp:LinkButton>
                    <asp:LinkButton ID="BTN_VIEW_DIR_BACK" CssClass="CADViewerButton_Back" runat="server" OnClientClick="js_ChangeView('VIEW_DIR_BACK')" OnClick="ChangeView" EnableViewState="false"></asp:LinkButton>
                    <asp:LinkButton ID="BTN_VIEW_DIR_LEFT" CssClass="CADViewerButton_Left" runat="server" OnClientClick="js_ChangeView('VIEW_DIR_LEFT')" OnClick="ChangeView" EnableViewState="false"></asp:LinkButton>
                    <asp:LinkButton ID="BTN_VIEW_DIR_BOTTOM" CssClass="CADViewerButton_Bottom" runat="server" OnClientClick="js_ChangeView('VIEW_DIR_BOTTOM')" OnClick="ChangeView" EnableViewState="false"></asp:LinkButton>
                    <asp:LinkButton ID="BTN_VIEW_DIR_ISO" CssClass="CADViewerButton_Iso" runat="server" OnClientClick="js_ChangeView('VIEW_DIR_ISO')" OnClick="ChangeView" EnableViewState="false"></asp:LinkButton>
                </asp:PlaceHolder>

                <div style="display: none">
                    <asp:Button ID="btExtChangeView" OnClick="ChangeView" runat="server" />
                </div>

                <div class="Spacer"></div>

                <ccPublisherWeb:ImageCheckbox ID="chkAutoPrev" CssClass="AutoPrev" AutoPostBack="true" OnCheckedChanged="AutoPrevCheckedChanged" runat="server" />

                <div style="display: none">
                    <asp:HiddenField ID="hdExtAutoPrev" runat="server" />
                    <asp:HiddenField ID="hdExtJavaFound" runat="server" />
                    <asp:Button ID="btExtAutoPrev" OnClick="ExtAutoPrevChecked" runat="server" />
                </div>
                
                <div class="Spacer"></div>

                <asp:PlaceHolder ID="plhJavaViewer" runat="server">
                    <asp:PlaceHolder ID="plhJavaViewer3D" runat="server">
                        <a class="CADViewerButton_3DViewer" onclick="start3DViewerExt()" title="<%# TextDic.TxGet("Text_Ansicht3DVorschau") %>"></a>
                    </asp:PlaceHolder>
                    <a class="CADViewerButton_2DViewer" onclick="start2DViewerExt()" title="<%# TextDic.TxGet("Text_Ansicht2DVorschau") %>"></a>
                </asp:PlaceHolder>

                
                <a class="CADViewerButton_Print" onclick="window.print();" title="<%# TextDic.TxGet("Text_Drucken") %>" style="display: none"></a>

                <div style="display: none">
                    <asp:Button ID="btPostbackViewer3D" OnClick="Start3DViewer" runat="server" />
                    <asp:Button ID="btPostbackViewer2D" OnClick="Start2DViewer" runat="server" />
                    <asp:Button ID="btPostback_SectionalView" OnClick="Start2DViewerSectionalView" runat="server" />
                </div>
            </div>
            <div class="Footer"></div>
        </div>
                     
        <asp:Panel ID="AutoPrevWarning" runat="server">
            <div id="AutoPrevInfoIcon"></div>
            <p>&nbsp;</p>
            <p><%# TextDic.TxGet("PreviewImage_Deactivated") %></p>
            <p>&nbsp;</p>
            <p><asp:LinkButton ID="lnkActivateAutPrev" runat="server" OnClick="AutoPrevActivate"><%# TextDic.TxGet("PreviewImage_ActivateQuestion") %></asp:LinkButton></p>
        </asp:Panel>

        <asp:Image ID="Prev3DImg" CssClass="Prev3DImg" runat="server" />
        
        <asp:PlaceHolder ID="phPoweredByCADClick" runat="server" Visible="false">
            <div id="pbcContainer"><a href="http://www.cadclick.com" target="_blank"><div id="pbcArrow"></div><span>Powered by CADClick<sup>&reg;</sup></span></a></div>
        </asp:PlaceHolder>

        <asp:PlaceHolder ID="ctrlPHLODButtonsContainer" runat="server">
            <script language="javascript" type="text/javascript">
                function js_ChangeLOD(LODStyle) {
                    $('#<%# ctrlPHLODStyle.ClientID %>').val(LODStyle);

                    $('input.ccQuest').each(function () {
                        var pos = $(this).attr("idx");
                        var text = $(this).val().toLowerCase();

                        if ("details" == text) {
                            var answerField = '#' + 'ccAnswer' + pos;
                            var cmpVal = $(answerField).val();

                            if (cmpVal != LODStyle) {
                                $(answerField).val(LODStyle);
                                ccjs_evaluateForm(pos);
                            }
                        }
                    });
                }
            </script>
                                
            <asp:HiddenField ID="ctrlPHLODStyle" runat="server" />

            <asp:PlaceHolder ID="ctrlPHLODDisplayToolBar" runat="server">
                <div id="ToolbarLOD" class="CADViewerButtonsLOD">
                    <div class="Header"></div>
                    <div class="Content">
                        <asp:Placeholder ID="ctrlPHLODButtons" runat="server"></asp:Placeholder>
                    </div>
                    <div class="Footer"></div>
                </div>
            </asp:PlaceHolder>

            <asp:PlaceHolder ID="ctrlPHLODDisplayDropDown" runat="server">
                <asp:PlaceHolder ID="ctrlLODDropDown" runat="server"></asp:PlaceHolder>
            </asp:PlaceHolder>
        </asp:PlaceHolder>

        <asp:HiddenField ID="hdAutoPrevCallExt" Value="false" runat="server" EnableViewState="true" />
        <asp:HiddenField ID="hdViewSetting" Value="" runat="server" EnableViewState="true" />
        <asp:HiddenField ID="hdEnable3DViewer" Value="false" runat="server" EnableViewState="true" />

        <script language="javascript" type="text/javascript">
            if ("<%# !Page.IsPostBack %>" == "<%# bool.TrueString %>") 
            {
                try {
                    if((typeof(parent.Leer) != undefined) && (typeof(parent.Leer.document.CADPrevForm) != undefined)) {
                        parent.Leer.document.CADPrevForm.AutoView.checked = <%# hdAutoPrevCallExt.Value %>;
                    }
                } catch (e) {}
            }
         </script>
    </ContentTemplate>
    <Triggers>                               
        <asp:AsyncPostBackTrigger ControlID="BTN_VIEW_DIR_FRONT" />
        <asp:AsyncPostBackTrigger ControlID="BTN_VIEW_DIR_RIGHT" />
        <asp:AsyncPostBackTrigger ControlID="BTN_VIEW_DIR_TOP" />
        <asp:AsyncPostBackTrigger ControlID="BTN_VIEW_DIR_BACK" />
        <asp:AsyncPostBackTrigger ControlID="BTN_VIEW_DIR_LEFT" />
        <asp:AsyncPostBackTrigger ControlID="BTN_VIEW_DIR_BOTTOM" />
        <asp:AsyncPostBackTrigger ControlID="BTN_VIEW_DIR_ISO" />
        <asp:AsyncPostBackTrigger ControlID="QNA_CHANGED" />                        
        <asp:AsyncPostBackTrigger ControlID="chkAutoPrev" />
    </Triggers>
</asp:UpdatePanel>
