<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="PageHeader.ascx.cs" Inherits="ccPublisherWeb.PageHeader" %>

<div id="<%# this.ID %>" class="<%# this.CssClass %>">
   <div class="Inner">
      <a id="lkParentDirLink" href="javascript:;" class="ParentDirLink" runat="server"></a>
      <span class="Label"><asp:Literal ID="lbTitle" runat="server" /></span>
   </div>
</div>

<script language="javascript" type="text/javascript">
   function phContentWidth() {
      return $("#<%# this.ID %> .Label").outerWidth(true) + $("#<%# this.ID %> .ParentDirLink").outerWidth(true);
   }

   <%--
      If the path string is too long so that it exceeds the maximum allowed page dimensions
      scale down the font of all items until it fits without any overflow on the right side.
   --%>
   $(function() {
      var fontSizeLoops = 3;
      var main = $("#<%# this.ID %>");
      var container = main.find(".Inner");

      var content = main.find(".Label");
      var firstEl = content.find("A:first");

      if(firstEl.length) {
         var currentFontSize = firstEl.css('font-size');
         var currentFontSizeNum = parseFloat(currentFontSize, 10);
         var newFontSize = currentFontSizeNum * 0.8;

         <%-- reduce font size until content fits --%>
         while((phContentWidth() > container.width()) && (fontSizeLoops > 0)) {
            fontSizeLoops--;;

            content.find("A").css("font-size", newFontSize);
         }

         var firstRemove = true;

         <%-- still any overflow? remove first elements --%>
         while((phContentWidth() > container.width()) && content.find("A").length) {
            if(firstRemove) {
               $("<span class=\"ParentDot\">...</span>").insertBefore(".Label A:first");
            }

            content.find("A:first").remove();

            if(!firstRemove) {
               content.find("IMG:nth-child(1)").remove();
            }

            firstRemove = false;
         }
      }
   });
</script>